#include <iostream>
#include <cstring>
#include "comm.h"
#include "cloud.h"
#include "clouds.h"

#include "global.h"

char* str_cpy(char* src, int start, int len) {
	int length = strlen(src) - start;
	int cpy_len = (len == -1) ? length : len;
	char* dest = new char[cpy_len + 1];

	for(int i = start; i < cpy_len + start; i++)
		dest[i - start] = src[i];
	dest[cpy_len] = '\0';

	return dest;
}
char* str_cut(char* src, int start) {
	int len_start = strlen(src);
	int len = len_start - start;
	char* dest;

	dest = new char[len + 1];
	for(int i = start; i < len + start; i++) 
		dest[i - start] = src[i];
	dest[len] = '\0';

	return dest;
}
char* str_get(char* src, char delim, bool remove) {
	char* dest;
	int i = 0, j, len = strlen(src);

	while(src[++i] != delim && i < len);

	dest = new char[i + 1];
	if(i == len) {
		strcpy(dest, src);
	} else {
		for(j = 0; j < i; j++)
			dest[j] = src[j];
		dest[j] = '\0';
		if(remove) {
			for(j = 0; j < len - i; j ++)
				src[j] = src[j + i + 1];
			src[j + 1];
		} else {
			for(j = 0; j < len - i; j ++)
				src[j] = src[j + i];
			src[j] = '\0';
		}
	}
	return dest;
}

Cloud* refresh_state(Comm* c, Clouds* clouds) {
	Cloud* tmp_cloud, * my_cloud;
	char* tmp_str, * tmp_str_part;
	int me, count = -1;

	clouds->flush();
	c->s("GET_STATE\n");

	tmp_str = c->r();
	tmp_str_part = str_get(tmp_str);
	if(strcmp(tmp_str_part, "BEGIN_STATE"))
		return NULL;

	clouds->set_iteration(atoi(tmp_str));
	delete [] tmp_str; delete [] tmp_str_part;

	tmp_str = c->r();
	tmp_str_part = str_get(tmp_str);
	if(strcmp(tmp_str_part, "YOU"))
		return NULL;
	me = atoi(tmp_str);
	delete [] tmp_str; delete [] tmp_str_part;

	tmp_str = c->r();
	while(strcmp(tmp_str, "END_STATE\r")) {
		tmp_str_part = str_get(tmp_str);
		if(strcmp(tmp_str_part, "THUNDERSTORM") == 0)
			tmp_cloud = new Cloud(tmp_str, THUNDER);
		else if( strcmp(tmp_str_part, "RAINCLOUD") == 0)
			tmp_cloud = new Cloud(tmp_str, RAIN);
		else
			return NULL;

		if(++count != me)
			clouds->add(tmp_cloud);	
		else
			my_cloud = tmp_cloud;
		delete [] tmp_str; delete [] tmp_str_part;
		tmp_str = c->r();
	}
	delete [] tmp_str;

	return my_cloud;
}